<?php

/**
 * The admin-specific functionality of the plugin.
 *
 * @link       https://getwpfunnels.com/
 * @since      1.0.0
 *
 * @package    Wpfnl_Pro_Gb
 * @subpackage Wpfnl_Pro_Gb/admin
 */

/**
 * The admin-specific functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    Wpfnl_Pro_Gb
 * @subpackage Wpfnl_Pro_Gb/admin
 * @author     WPFunnels Team <support@getwpfunnels.com>
 */
class Wpfnl_Pro_Gb_Admin {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $plugin_name       The name of this plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct( $plugin_name, $version ) {

		$this->plugin_name = $plugin_name;
		$this->version = $version;

	}

	/**
	 * Register the stylesheets for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Wpfnl_Pro_Gb_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Wpfnl_Pro_Gb_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_style( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'css/wpfnl-pro-gb-admin.css', array(), $this->version, 'all' );

	}

	/**
	 * Register the JavaScript for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Wpfnl_Pro_Gb_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Wpfnl_Pro_Gb_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_script( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'js/wpfnl-pro-gb-admin.js', array( 'jquery' ), $this->version, false );

	}

	/**
	 * Update GBF condition
	 * 
	 * @param Array $addons
	 * @return Array $addons 
	 */
	public function update_gbf_condition( $addons ){
		if( isset($addons['global_funnel']['features']['trigger_options']) ){
			$addons['global_funnel']['features']['trigger_options']['not_category'] 		= __('Product category is not', 'wpfnl-pro-gb');
			$addons['global_funnel']['features']['trigger_options']['cart_total_equal'] 	= __('Cart total is equal to', 'wpfnl-pro-gb');
			$addons['global_funnel']['features']['trigger_options']['cart_total_greater'] 	= __('Cart total is greater than', 'wpfnl-pro-gb');
			$addons['global_funnel']['features']['trigger_options']['cart_total_less'] 		= __('Cart total is less than', 'wpfnl-pro-gb');
			$addons['global_funnel']['features']['trigger_options']['quantity'] 			= __('Product quantity is', 'wpfnl-pro-gb');
			$addons['global_funnel']['features']['trigger_options']['quantity_greater'] 	= __('Product quantity is greater than', 'wpfnl-pro-gb');
			$addons['global_funnel']['features']['trigger_options']['highest_sold'] 		= __('Highest Sold product is in the cart', 'wpfnl-pro-gb');
			$addons['global_funnel']['features']['trigger_options']['least_sold'] 			= __('Least Sold product is in the cart', 'wpfnl-pro-gb');
			$addons['global_funnel']['features']['trigger_options']['popular'] 				= __('Most Popular product is in the cart', 'wpfnl-pro-gb');
			$addons['global_funnel']['features']['trigger_options']['highest_rating'] 		= __('Highest Rated product is in the cart', 'wpfnl-pro-gb');
			$addons['global_funnel']['features']['trigger_options']['most_review'] 			= __('Most reviewed product is in the cart', 'wpfnl-pro-gb');
			$addons['global_funnel']['features']['trigger_options']['shipping'] 			= __('Shipping class is', 'wpfnl-pro-gb');
			$addons['global_funnel']['features']['trigger_options']['tag'] 					= __('Product Tag is', 'wpfnl-pro-gb');
			$addons['global_funnel']['features']['trigger_options']['tag_not'] 					= __('Product Tag is not', 'wpfnl-pro-gb');
			$addons['global_funnel']['features']['trigger_options']['role'] 				= __('User Role is', 'wpfnl-pro-gb');
			$addons['global_funnel']['features']['trigger_options']['dateRange'] 			= __('Date is within range', 'wpfnl-pro-gb');
			$addons['global_funnel']['features']['trigger_options']['date'] 				= __('Date is', 'wpfnl-pro-gb');
			$addons['global_funnel']['features']['trigger_options']['product_not'] 			= __('Product is not', 'wpfnl-pro-gb');
			$addons['global_funnel']['features']['trigger_options']['returningCustomer'] 	= __('User is a returning customer', 'wpfnl-pro-gb');
			$addons['global_funnel']['features']['trigger_options']['returningCustomerWithRange'] 	= __('User is a a returning Customer within last X days', 'wpfnl-pro-gb');
		}
		return $addons;
	}


	/**
	 * Update GBF offer conditions
	 * 
	 * @param Array
	 * @return Array
	 */
	public function update_gbf_offer_condition( $conditions ){

		$conditions['moreQuantity'] 				= __('More Quantity of the main product in cart', 'wpfnl-pro-gb');
		$conditions['randomProduct'] 				= __('Random product in category', 'wpfnl-pro-gb');
        $conditions['randomProductInsideCategoryWithinPrice'] = __('Random product in category within a price range', 'wpfnl-pro-gb');
		$conditions['highestSold'] 					= __('Highest sold product in store', 'wpfnl-pro-gb');
		$conditions['highestSoldInsideCategory'] 	= __('Highest sold product in category', 'wpfnl-pro-gb');
        $conditions['highestSoldInsideTag'] 	    = __('Highest sold product with tag', 'wpfnl-pro-gb');
		$conditions['leastSold'] 					= __('Least sold product in store', 'wpfnl-pro-gb');
		$conditions['randomProductInTag'] 			= __('Random product with tag', 'wpfnl-pro-gb');
        $conditions['randomProductInsideTagWithinPrice'] = __('Random product with tag within a price range', 'wpfnl-pro-gb');
		$conditions['randomInShop'] 				= __('Random product in shop ', 'wpfnl-pro-gb');
		return $conditions;
	}


	/**
	 * Delete transient for check update
	 * 
	 * @since 1.0.7
	 */
	public function check_update_transient(){
		delete_site_transient( 'update_plugins' );
		$this->clear_gbf_update_check_transient();
	}


	/**
     * clear gbf update check transient data
     *
     * @since 1.0.7
     */
    private function clear_gbf_update_check_transient() {
        global $wpdb;
        $sql   = "DELETE a, b FROM $wpdb->options a, $wpdb->options b
		WHERE a.option_name LIKE %s
		AND a.option_name NOT LIKE %s
		AND b.option_name = CONCAT( '_site_transient_timeout_', SUBSTRING( a.option_name, 17 ) )";
        $wpdb->query( $wpdb->prepare( $sql, $wpdb->esc_like( '_site_transient_wpfunnelsprogbf-check_for_plugin_update' ) . '%', $wpdb->esc_like( '_site_transient_timeout_' ) . '%' ) );

    }

}
