<?php

declare(strict_types=1);

namespace ProjectHuddle\Vendor\Laminas\ServiceManager\Factory;

use ProjectHuddle\Vendor\Laminas\ServiceManager\Exception\ServiceNotCreatedException;
use ProjectHuddle\Vendor\Laminas\ServiceManager\Exception\ServiceNotFoundException;
use ProjectHuddle\Vendor\Psr\Container\ContainerExceptionInterface;
use ProjectHuddle\Vendor\Psr\Container\ContainerInterface;

/**
 * Delegator factory interface.
 *
 * Defines the capabilities required by a delegator factory. Delegator
 * factories are used to either decorate a service instance, or to allow
 * decorating the instantiation of a service instance (for instance, to
 * provide optional dependencies via setters, etc.).
 */
interface DelegatorFactoryInterface
{
    /**
     * A factory that creates delegates of a given service
     *
     * @param  string                $name
     * @psalm-param callable():mixed $callback
     * @param  null|array<mixed>     $options
     * @return object
     * @throws ServiceNotFoundException If unable to resolve the service.
     * @throws ServiceNotCreatedException If an exception is raised when creating a service.
     * @throws ContainerExceptionInterface If any other error occurs.
     */
    public function __invoke(ContainerInterface $container, $name, callable $callback, ?array $options = null);
}
