<?php

if ( ! defined( 'ABSPATH' ) ) {
	die;
}

class Opengraphiq_Public {

	
	private $opengraphiq;

	private $version;

	private $option_name = 'opengraphiq_setting';
	private $plugin_name = 'opengraphiq';

	public function __construct( $opengraphiq, $version ) {

		$this->opengraphiq = $opengraphiq;
		$this->version = $version;

	}

	/**
	 * Register the stylesheets for the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Opengraphiq_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Opengraphiq_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_style( $this->opengraphiq, plugin_dir_url( __FILE__ ) . 'css/opengraphiq-public.css', array(), $this->version, 'all' );

	}

	/**
	 * Register the JavaScript for the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Opengraphiq_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Opengraphiq_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_script( $this->opengraphiq, plugin_dir_url( __FILE__ ) . 'js/opengraphiq-public.js', array( 'jquery' ), $this->version, false );
	}

	public function start_head_buffer(){
		if(is_page() || is_single()){
			global $post;
			$ogtemplate = $this -> opengraphiq_get_template_by_id( $post );

			if($ogtemplate != ''){
				$ogimageurl = get_post_meta( $post -> ID, 'opengraphiqtemplates_image', true );
				if ($ogimageurl != ''){
					ob_start();
				}
			}
		}
		
	}

	public function opengraphiq_replacements($input){
		global $post;

		$pagetitle = wp_title( '|', false, 'right' );
		$input = str_replace( '%site_title%', $pagetitle, $input);

		$posttitle = $post->post_title;
		$input = str_replace( '%post_title%', $posttitle, $input);

		$post_id = $post->ID;
		$postcategory = $this -> get_post_primary_category($post_id);
		if($postcategory){
			$primcat = $postcategory['primary_category'];
			$input = str_replace( '%post_category%', $primcat->name, $input);
		}

		$post_excerpt = strip_tags($post->post_excerpt);
		$input = str_replace( '%post_excerpt%', $post_excerpt, $input);
		$input = str_replace( '%product_description%', $post_excerpt, $input);

		if (str_contains($input, '%meta_')){
			$metaarr = $this -> getContents($input, '%meta_', '%');
			foreach ($metaarr as $v) {
				$meta_value = get_post_meta( $post_id, $v, true );
				$input = str_replace( '%meta_' . $v . '%', $meta_value, $input);
			}
		}


		$author_id = $post->post_author;
		$author_name = get_the_author_meta('nicename', intval($author_id) );
		$input = str_replace( '%post_author%', $author_name, $input);

		$formatted_date = get_the_modified_date( '', $post );
		$input = str_replace( '%post_date%', $formatted_date, $input);

		return $input;
	}

	public function opengraphiq_insert_tags($title){

		$str_to_add = '';
		if(is_page() || is_single()){
			global $post;
			$ogtemplate = $this -> opengraphiq_get_template_by_id( $post );
			
			if($ogtemplate != ''){

				$val = get_option( $this->option_name . '_debug_mode' );

				if($val == "on") {
					$debugclass = "class='opengraphiq'";
				} else {
					$debugclass = "";
				}

				$ogimageurl = get_post_meta( $post -> ID, 'opengraphiqtemplates_image', true );
				$option_facebook_app_id = get_option( $this->option_name . '_facebook_app_id' );
				$option_twitter_site = get_option( $this->option_name . '_twitter_site' );

				$ogtitle = get_post_meta( array_key_first($ogtemplate), 'opengraphiqtemplates_og_title', true );

				if( $ogtitle ){
					if ( trim($ogtitle) == '' ){
						$ogtitle = '%post_title%';
					}
				} else {
					$ogtitle = '%post_title%';
				}

				$ogtitle = $this -> opengraphiq_replacements($ogtitle);

				$ogtitle = apply_filters( 'opengraphiq_title', $ogtitle );

				$ogdescription = get_post_meta( array_key_first($ogtemplate), 'opengraphiqtemplates_og_description', true );

				if( $ogdescription ){
					if ( trim($ogdescription) == '' ){
						$ogdescription = '%post_excerpt%';
					}
				} else {
					$ogdescription = '%post_excerpt%';
				}

				$ogdescription = $this -> opengraphiq_replacements($ogdescription);

				$ogdescription = apply_filters( 'opengraphiq_description', $ogdescription );

				$ogtype = get_post_meta( array_key_first($ogtemplate), 'opengraphiqtemplates_og_type', true );

				$str_to_add .= "\t<ogmeta property='og:url' content='" . esc_attr(get_permalink( $post -> ID )) . "' " . $debugclass . "/>\r\n";
				$str_to_add .= "\t<ogmeta property='og:locale' content='" . esc_attr(get_locale()) . "' " . $debugclass . "/>\r\n";
				$str_to_add .= "\t<ogmeta property='og:site_name' content='" . esc_attr(get_bloginfo( 'name' )) . "' " . $debugclass . "/>\r\n";

				if( $ogtitle ) {
					$str_to_add .= "\t<ogmeta property='og:title' content='" . esc_attr( $ogtitle ) . "' " . $debugclass . "/>\r\n";
				}

				if( $ogdescription ) {
					$str_to_add .= "\t<ogmeta property='og:description' content='" . esc_attr( $ogdescription ) . "' " . $debugclass . "/>\r\n";
				}

				if( $ogtype ) {
					$str_to_add .= "\t<ogmeta property='og:type' content='" . esc_attr( $ogtype ) . "' " . $debugclass . "/>\r\n";
					if ( $ogtype == 'article') {
						$author_id = $post->post_author;
						$str_to_add .= "\t<ogmeta name='author' content='" . esc_attr( get_the_author_meta( 'nicename', $author_id ) ) . "' " . $debugclass . "/>\r\n";
						$str_to_add .= "\t<ogmeta property='article:published_time' content='" . date('c', get_post_timestamp( $post, 'date' )) . "' " . $debugclass . "/>\r\n";
						$str_to_add .= "\t<ogmeta property='article:modified_time' content='" . date('c', get_post_timestamp( $post, 'modified' )) . "' " . $debugclass . "/>\r\n";
					}
				} else {
					$str_to_add .= "\t<ogmeta property='og:type' content='website' " . $debugclass . "/>\r\n";
				}

				if( $option_facebook_app_id ) {
					$str_to_add .= "\t<ogmeta property='fb:app_id' content='" . esc_attr( $option_facebook_app_id ) . "' " . $debugclass . "/>\r\n";
				}

				if ($ogimageurl != ''){
					
					if(is_ssl()){
						$str_to_add .= "\t<ogmeta property='og:image:secure_url' content='" . esc_attr(get_site_url(null, $ogimageurl)) . "' " . $debugclass . "/>\r\n";
					}
					$str_to_add .= "\t<ogmeta property='og:image' content='" . esc_attr(get_site_url(null, $ogimageurl)) . "' " . $debugclass . "/>\r\n";
					$str_to_add .= "\t<ogmeta property='og:image:type' content='image/jpeg' " . $debugclass . "/>\r\n";
					$size = getimagesize( $this->attachment_url_to_path($ogimageurl) );
					$str_to_add .= "\t<ogmeta property='og:image:height' content='" . esc_attr($size[1]) . "' " . $debugclass . "/>\r\n";
					$str_to_add .= "\t<ogmeta property='og:image:width' content='" . esc_attr($size[0]) . "' " . $debugclass . "/>\r\n";
					
					$str_to_add .= "\t<ogmeta name='twitter:image' content='" . esc_attr(get_site_url(null, $ogimageurl)) . "' " . $debugclass . "/>\r\n";
				}
				
				$str_to_add .= "\t<ogmeta name='twitter:card' content='summary_large_image' " . $debugclass . "/>\r\n";

				if( $option_twitter_site ) {
					$str_to_add .= "\t<ogmeta name='twitter:site' content='" . esc_attr( $option_twitter_site ) . "' " . $debugclass . "/>\r\n";
				}

				$str_to_add = str_replace("<ogmeta", "<meta", $str_to_add);

				$tagarr = array( 'meta' => array ( 'property' => array(), 'content' => array(), 'name' => array(), 'class' => array() ), 'ogmeta' => array ( 'property' => array(), 'content' => array(), 'name' => array(), 'class' => array() ) );
				$str_to_add = apply_filters( 'opengraphiq_markup', $str_to_add );
				echo wp_kses( $str_to_add, $tagarr );
			}
		}
	}

	public function get_post_primary_category($post_id, $term='category', $return_all_categories=false){
		$return = array();

		if (class_exists('WPSEO_Primary_Term')){
			// Show Primary category by Yoast if it is enabled & set
			$wpseo_primary_term = new WPSEO_Primary_Term( $term, $post_id );
			$primary_term = get_term($wpseo_primary_term->get_primary_term());

			if (!is_wp_error($primary_term)){
				$return['primary_category'] = $primary_term;
			}
		}

		if (empty($return['primary_category']) || $return_all_categories){
			$categories_list = get_the_terms($post_id, $term);

			if (empty($return['primary_category']) && !empty($categories_list)){
				$return['primary_category'] = $categories_list[0];  
			}
			if ($return_all_categories){
				$return['all_categories'] = array();

				if (!empty($categories_list)){
					foreach($categories_list as &$category){
						$return['all_categories'][] = $category->term_id;
					}
				}
			}
		}

		return $return;
	}

	public function getContents($str, $startDelimiter, $endDelimiter) {
		$contents = array();
		$startDelimiterLength = strlen($startDelimiter);
		$endDelimiterLength = strlen($endDelimiter);
		$startFrom = $contentStart = $contentEnd = 0;
		while (false !== ($contentStart = strpos($str, $startDelimiter, $startFrom))) {
		  $contentStart += $startDelimiterLength;
		  $contentEnd = strpos($str, $endDelimiter, $contentStart);
		  if (false === $contentEnd) {
			break;
		  }
		  $contents[] = substr($str, $contentStart, $contentEnd - $contentStart);
		  $startFrom = $contentEnd + $endDelimiterLength;
		}
	  
		return $contents;
	  }

	public function end_head_buffer(){
		if(is_page() || is_single()){
			global $post;
			$ogtemplate = $this -> opengraphiq_get_template_by_id( $post );

			if($ogtemplate != ''){
				$ogimageurl = get_post_meta( $post -> ID, 'opengraphiqtemplates_image', true );
				if ($ogimageurl != ''){
					$outputbuffer = ob_get_clean();
					$outputbuffer = $this -> removeTags($outputbuffer, $ogimageurl);
					echo str_replace("<ogmeta", "<meta", $outputbuffer);
				}
			}
		}
	}

	private function removeTags( $markup, $img ){

    	// - do the og:image and twitter card magic
		$replaceRegexOgImage = [
			"/<meta[^>]*property=[\"']og:image[\"'][^>]*\>/",
			"/<meta[^>]*property=[\"']og:image:secure_url[\"'][^>]*\>/",
			"/<meta[^>]*property=[\"']og:image:height[\"'][^>]*\>/",
			"/<meta[^>]*property=[\"']og:image:width[\"'][^>]*\>/",
		];

		$replaceRegexTwitter = [
			"/<meta[^>]*name=[\"']twitter:image[\"'][^>]*\>/",
			"/<meta[^>]*name=[\"']twitter:card[\"'][^>]*\>/",
		];
        
		$replaceRegexes = [];
            
		$replaceRegexes = array_merge(
			$replaceRegexes,
			$replaceRegexOgImage
		);

		$replaceRegexes = array_merge(
			$replaceRegexes,
			$replaceRegexTwitter
		);

		foreach ($replaceRegexes as $regex) {
			$matches = [];
			preg_match_all($regex, $markup, $matches);
			
			$matches = array_unique( $this -> opengraphiq_array_get($matches, 0, []));
			
			foreach ($matches as $match) {
				$markup = str_replace(
					$match,
					$this->_wrap_match($match, $img),
					$markup
				);
			}

			foreach ($matches as $match) {
				$markup = $this->_delete_initial($match, $markup);
			}
		}
        
        return $markup;
    }

	private function attachment_url_to_path( $url )
	{
		$parsed_url = parse_url( $url );
		if(empty($parsed_url['path'])) return false;
		$file = ABSPATH . ltrim( $parsed_url['path'], '/');
		if (file_exists( $file)) return $file;
		return false;
	}

	private function getpngsize( $img_loc ) {
		$handle = fopen( $img_loc, "rb" ) or die( "Invalid file stream." );
	
		if ( ! feof( $handle ) ) {
			$new_block = fread( $handle, 24 );
			if ( $new_block[0] == "\x89" &&
				$new_block[1] == "\x50" &&
				$new_block[2] == "\x4E" &&
				$new_block[3] == "\x47" &&
				$new_block[4] == "\x0D" &&
				$new_block[5] == "\x0A" &&
				$new_block[6] == "\x1A" &&
				$new_block[7] == "\x0A" ) {
					if ( $new_block[12] . $new_block[13] . $new_block[14] . $new_block[15] === "\x49\x48\x44\x52" ) {
						$width  = unpack( 'H*', $new_block[16] . $new_block[17] . $new_block[18] . $new_block[19] );
						$width  = hexdec( $width[1] );
						$height = unpack( 'H*', $new_block[20] . $new_block[21] . $new_block[22] . $new_block[23] );
						$height  = hexdec( $height[1] );
	
						return array( $width, $height );
					}
				}
			}
	
		return false;
	}

	private function _wrap_match($match, $img)
    {
		$str_to_add = '';

		if (str_contains($match, 'og:image:secure_url')) {
			$str_to_add = '<meta property="og:image:secure_url" content="' . get_site_url(null, $img) . '" />';
		} elseif (str_contains($match, 'og:image:height')) {
			$size = getimagesize( $this->attachment_url_to_path($img) );
			$str_to_add = '<meta property="og:image:height" content="' . $size[1] . '" />';
		} elseif (str_contains($match, 'og:image:width')) {
			$size = getimagesize( $this->attachment_url_to_path($img) );
			$str_to_add = '<meta property="og:image:width" content="' . $size[0] . '" />';
		} elseif (str_contains($match, 'og:image')) {
			$str_to_add = '<meta property="og:image" content="' . get_site_url(null, $img) . '" />';
		} elseif (str_contains($match, 'twitter:image')) {
			$str_to_add = '<meta name="twitter:image" content="' . get_site_url(null, $img) . '" />';
		} elseif (str_contains($match, 'twitter:card')) {
			$str_to_add = '<meta name="twitter:card" content="summary_large_image" />';
		}

		$val = get_option( $this->option_name . '_debug_mode' );

		if($val == "on") {
			$match =  str_replace("<meta", "<-m-e-t-a-replaced", $match);
        	return $str_to_add . "\r\n\t" . "<!-- REPLACED BY OPENGRAPHIQ: " . $match . " -->";
		} else {
			return $str_to_add;
		}
    }

	private function _delete_initial($match, $markup)
    {
		$final_ret = '';

		if (str_contains($match, 'og:image:secure_url')) {
			$pattern = "/\\t<ogmeta[^>]*property=[\"']og:image:secure_url[\"'][^>]*\>\\r\\n/";
		} elseif (str_contains($match, 'og:image:height')) {
			$pattern = "/\\t<ogmeta[^>]*property=[\"']og:image:height[\"'][^>]*\>\\r\\n/";
		} elseif (str_contains($match, 'og:image:width')) {
			$pattern = "/\\t<ogmeta[^>]*property=[\"']og:image:width[\"'][^>]*\>\\r\\n/";
		} elseif (str_contains($match, 'og:image')) {
			$pattern = "/\\t<ogmeta[^>]*property=[\"']og:image[\"'][^>]*\>\\r\\n/";
		} elseif (str_contains($match, 'twitter:image')) {
			$pattern = "/\\t<ogmeta[^>]*name=[\"']twitter:image[\"'][^>]*\>\\r\\n/";
		} elseif (str_contains($match, 'twitter:card')) {
			$pattern = "/\\t<ogmeta[^>]*name=[\"']twitter:card[\"'][^>]*\>\\r\\n/";
		}
		$final_ret = preg_replace($pattern, '', $markup);
        return $final_ret;
    }

	private function opengraphiq_get_template_by_id( $post ){
		$meta = get_post_meta( $post -> ID, $this->option_name . '_post_meta', true );

		$post_type = $post -> post_type;

		if ( $meta == '0' ){
			$ogret = apply_filters( 'opengraphiq_template', '' );
			return $ogret;
		}

		if ( $meta != '-1' && $meta != ''){
			$ret_val[$meta] = get_post($meta) -> post_title;
			$ogret = apply_filters( 'opengraphiq_template', $ret_val );
			return $ogret;	
		}
		
		$og_rules = get_option( $this->option_name . '_og_rules' );
		if($og_rules){
			$og_rules_array = json_decode(stripslashes($og_rules), true);
			foreach( $og_rules_array as $og_rule){
				$term_found = false;
				$term_temp = get_term( $og_rule["term"]["id"] );

				if (has_term( intval($og_rule["term"]["id"]), $term_temp->taxonomy, $post )){
					$term_found = true;
				}
				
				if($term_found){
					$ret_val[$og_rule["template"]] = get_post($og_rule["template"]) -> post_title;
					$ogret = apply_filters( 'opengraphiq_template', $ret_val );
					return $ogret; 
				}
			}
		}

		$optionval = get_option( $this->option_name . '_cp_template' );
		$needsfiltering = true;
		if ($optionval) {
			if( array_key_exists($post_type, $optionval) ) {
				if( $optionval[$post_type] !=  '-1'  && $meta != '' ){
					if( $optionval[$post_type] == '0' ){
						$ogret = apply_filters( 'opengraphiq_template', '' );
						return $ogret;
					}
					$ret_val[$optionval[$post_type]] = get_post($optionval[$post_type]) -> post_title;
					$ogret = apply_filters( 'opengraphiq_template', $ret_val );
					return $ogret;
				} else {
					$val = get_option( $this->option_name . '_default_template' );
					if( $val  == '0' || $val == ''){
						return '';
					}
					$ret_val[$val] = get_post($val) -> post_title;
					$ogret = apply_filters( 'opengraphiq_template', $ret_val );
					return $ogret;
				}
			}
		}
		$val = get_option( $this->option_name . '_default_template' );
		$ret_val[$val] = get_post($val) -> post_title;
		$ogret = apply_filters( 'opengraphiq_template', $ret_val );
		return $ogret;
	}

	private function opengraphiq_array_get($array, $key, $default = null)
    {
        if (is_null($key)) {
            return $array;
        }
        if (isset($array[$key])) {
            return $array[$key];
        }
        foreach (explode(".", $key) as $segment) {
            if (!is_array($array) || !array_key_exists($segment, $array)) {
                return $this -> opengraphiq_value($default);
            }
            $array = $array[$segment];
        }
        return $array;
    }

	private function opengraphiq_value($value)
    {
        return $value instanceof Closure ? $value() : $value;
    }

}
