<?php

if ( ! defined( 'ABSPATH' ) ) {
	die;
}

$option_facebook_app_id = get_option( $this->option_name . '_facebook_app_id' );
$option_twitter_site = get_option( $this->option_name . '_twitter_site' );
$og_rules = get_option( $this->option_name . '_og_rules' );

?>

<div class="wrap">
    <h2><?php echo esc_html__('OpenGraphiq Settings', 'opengraphiq') ?></h2>
    <form method="post">
        <input type="hidden" name="og_template_nonce" value="<?php echo esc_attr($nonce_value) ?>">
        <h2><?php echo esc_html__('General Settings', 'opengraphiq') ?></h2>
        <p><?php echo esc_html__('Please choose the default OpenGraphiq template to be used. This can be overriden for individual post types or even individual posts.', 'opengraphiq') ?></p>
        <table class="form-table" role="presentation">
            <tbody>
                <tr>
                    <th scope="row">
                        <label for="opengraphiq_setting_default_template"><?php echo esc_html__('Default template', 'opengraphiq') ?></label>
                    </th>
                    <td>
                        <?php $this->opengraphiq_setting_default_template_cb(); ?>
                    </td>
                </tr>
            </tbody>
        </table>
        <h2>Post types</h2>
        <p>Please choose the OpenGraphiq templates to be used with respective post types.</p>
        <table class="form-table" role="presentation">
            <tbody>
                <?php $this->opengraphiq_setting_posttypes_template_cb(); ?>
            </tbody>
        </table>
        <h2>Facebook Settings</h2>
        <p>In order to use Facebook Insights you must add the app ID to your page. Insights lets you view analytics for traffic to your site from Facebook. Find the app ID in your <a href="https://developers.facebook.com/apps/redirect/dashboard" target="_blank" >App Dashboard.</a></p>
        <table class="form-table" role="presentation">
            <tbody>
                <tr>
                    <th scope="row"><label for="<?php echo($this->option_name . '_facebook_app_id') ?>">Facebook app ID</label></th>
                    <td><input type="text" name="<?php echo($this->option_name . '_facebook_app_id') ?>" id="<?php echo($this->option_name . '_facebook_app_id') ?>" value="<?php echo(esc_attr($option_facebook_app_id)) ?>"></td>
                </tr>
            </tbody>
        </table>
        <h2>Twitter Settings</h2>
        <p>The Twitter @username the card should be attributed to.</p>
        <table class="form-table" role="presentation">
            <tbody>
                <tr>
                    <th scope="row"><label for="<?php echo($this->option_name . '_twitter_site') ?>">Twitter username (include @)</label></th>
                    <td><input type="text" placeholder="@username" name="<?php echo($this->option_name . '_twitter_site') ?>" id="<?php echo($this->option_name . '_twitter_site') ?>" value="<?php echo(esc_attr($option_twitter_site)) ?>"></td>
                </tr>
            </tbody>
        </table>
        <h2>Debug mode</h2>
        <p>If in debug mode, the plugin prints class='opengraphiq' within generated meta tags so you can easily identify the plugin's output on frontend</p>
        <table class="form-table" role="presentation">
            <tbody>
                <?php $this->opengraphiq_setting_debug_cb(); ?>
            </tbody>
        </table>
        <h2>Additional rules</h2>
        <p>Here you can define additional template rules based on post category, tag, product category or product tag</p>
        <input type="hidden" id="og_rules" name="og_rules" value="<?php echo esc_attr($og_rules) ?>">
        <?php echo '<div id="opengraphiqrules" class="og-rules-panel"></div>' ?>
        <p class="submit"><input type="submit" name="submit" id="submit" class="button button-primary" value="<?php echo esc_html__('Save changes', 'opengraphiq')?>"></p>
    </form>
</div> 
