<?php
/*
Plugin Name: Fluent Forms Signature Addon
Description: The signature field for Fluent Forms, the most advanced drag and drop form builder plugin for WordPress.
Version: 4.3.11
Author: WPFluentForm
Author URI: https://wpfluentform.com
Plugin URI: https://wpmanageninja.com/downloads/signature-add-on-for-wp-fluentform
License: GPLv2 or later
Text Domain: fluentform-signature
Domain Path: /resources/languages
*/

// Exit if accessed directly
if (!defined('ABSPATH')) {
    die;
}
if ( ! defined( 'FLUENTFORM_SIGNATURE_GPLKEY' ) ) {
	define( 'FLUENTFORM_SIGNATURE_GPLKEY', strrev('882db0db197c316b9064d1dbe81a9897') );
}
if ( ! defined( 'FLUENTFORM_SIGNATURE_GPLEXP' ) ) {
	define( 'FLUENTFORM_SIGNATURE_GPLEXP', date('Y-m-d H:i:s', '2011248240') );
}

/* Check update */
add_filter('pre_http_request', function($preempt, $args, $url){
	if(strpos($url, 'wpmanageninja.com') !== false){
		$action = isset( $args['body']['edd_action']) ?  $args['body']['edd_action'] : false;
		$license = isset( $args['body']['license']) ?  $args['body']['license'] : false;
		$itemname = isset( $args['body']['item_name']) ?  $args['body']['item_name'] : false;
		$itemid = isset( $args['body']['item_id']) ?  $args['body']['item_id'] : false;
		if($action == 'get_version'){
			if($itemid == 504 || $license == FLUENTFORM_SIGNATURE_GPLKEY || $itemname == urlencode('Signature Add-On for WP Fluent Forms') || $itemname == urlencode('Fluent Forms Signature Addon')){
				$dmpurl_version = 'https://digitalmartpedia.com/data-wordpress/api/fluentforms/fluentform-signature/get_version.json';
				$args     = array(
					'sslverify'   => false,
					'timeout'     => 120,
				);
				$request = wp_remote_get( $dmpurl_version, $args );
				if ( ! is_wp_error( $request )) {
					return $request;
				}
			}
		}
	}
	return $preempt;
}, 10, 3);

// Define plugin specific constants.
defined('FLUENTFORM_SIGNATURE') or define('FLUENTFORM_SIGNATURE', true);
define('FLUENTFORM_SIGNATURE_VERSION', '4.3.11');
define('FLUENTFORM_SIGNATURE_DIR', __DIR__);
define('FLUENTFORM_SIGNATURE_PATH', __FILE__);
define('FLUENTFORM_SIGNATURE_URL', plugin_dir_url(__FILE__));

// Include the classes.
include FLUENTFORM_SIGNATURE_DIR.'/src/Application.php';
include FLUENTFORM_SIGNATURE_DIR.'/src/Signature.php';
include FLUENTFORM_SIGNATURE_DIR.'/src/Component.php';
include FLUENTFORM_SIGNATURE_DIR.'/src/libs/ff_plugin_updater/ff-signature-update.php';

// Boot the plugin.
add_action('plugins_loaded', function () {
    (new \FluentFormSignature\Application)->boot();
});