<?php
/*
 * @var $booking \FluentBooking\App\Models\Booking
 */
?>
<div class="fcal_confirmation">
    <?php do_action('fluent_booking/booking_details_header', $booking); ?>
    <div class="fcal_confirm_header">
        <?php if ($booking->status == 'scheduled'): ?>
            <div class="fcal_check_holder" style="min-height: 50px;">
                <img style="max-width: 44px;" src="<?php echo \FluentBooking\App\App::getInstance('url.assets'); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>/images/check-mark.png" />
            </div>
        <?php endif; ?>
        <h2><?php echo esc_html($title); ?></h2>
        <p><?php echo wp_kses_post($sub_heading); ?></p>
    </div>
    <div class="fcal_confirm_body">
        <?php foreach ($sections as $section): ?>
            <div class="fcal_confirm_section">
                <div class="fcal_confirm_section_title">
                    <h4><?php echo esc_html($section['title']); ?></h4>
                </div>
                <div class="fcal_confirm_section_content">
                    <?php echo wp_kses_post($section['content']); ?>
                </div>
            </div>
        <?php endforeach; ?>

        <?php if($extra_html): ?>
        <hr />
        <div class="fcal_payment_html">
            <h3 style="margin-bottom: 10px;"><?php esc_html_e('Payment Details', 'fluent-booking-pro'); ?></h3>
            <?php echo $extra_html; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
        </div>
        <style>
            .fluent_booking_payment_receipt {
                background: transparent !important;
                padding: 0 !important;
            }
            .fcal_payment_html h4 {
                margin: 10px 0;
            }
        </style>
        <?php endif; ?>

        <?php if ($action_type == 'cancel'): ?>
            <div class="fcal_booking_manage fcal_cancellation_wrap fcal_action_<?php esc_attr($action_type); ?>">
                <form id="fcal_cancellation_form" action="<?php echo esc_url($action_url); ?>" method="POST"
                        class="fcal_form_cancellation">
                    <label for="cancellation_reason"><?php esc_html_e('Reason for cancellation', 'fluent-booking-pro') ?></label>
                    <div class="fcal_form_field">
                <textarea placeholder="<?php esc_attr_e('Please provide cancellation reason', 'fluent-booking-pro'); ?>"
                            name="cancellation_reason" id="cancellation_reason" rows="3"></textarea>
                    </div>
                    <div class="fcal_form_actions">
                        <a href="<?php echo esc_url($booking->getConfirmationUrl()); ?>"
                            class="fcal_btn fcal_btn_secondary"><?php esc_html_e('Nevermind', 'fluent-booking-pro'); ?></a>
                        <button class="fcal_btn fcal_btn_primary fcal_cancel_btn"
                                type="submit"><?php esc_html_e('Cancel Booking', 'fluent-booking-pro'); ?></button>
                    </div>
                </form>
            </div>
        <?php else: ?>
            <?php if ($booking->canCancel() || $booking->canReschedule()): ?>
                <div class="fcal_booking_manage fcal_normal_booking_footer">
                    <?php echo esc_html_e('Need to make a change?', 'fluent-booking-pro') ?>
                    <?php if ($booking->canCancel()): ?>
                        <a href="<?php echo esc_url($booking->getCancelUrl()); ?>"><?php esc_html_e('Cancel', 'fluent-booking-pro') ?></a>
                    <?php endif; ?>
                    <?php ($booking->canCancel() && $booking->canReschedule()) ? esc_html_e('or', 'fluent-booking-pro') : ''; ?>
                    <?php if ($booking->canReschedule()): ?>
                        <a href="<?php echo esc_url($booking->getRescheduleUrl()); ?>"><?php esc_html_e('Reschedule', 'fluent-booking-pro');  ?></a>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
        <?php endif; ?>

        <?php if ($bookmarks): ?>
            <div class="fcal_booking_manage fcal_to_calendars">
                <span><?php esc_html_e('Add to calendar', 'fluent-booking-pro'); ?></span>
                <div class="fcal_cal_items">
                    <?php foreach ($bookmarks as $bookmark): ?>
                    <div title="<?php echo esc_attr($bookmark['title']); ?>">
                        <a href="<?php echo esc_url($bookmark['url']); ?>" target="_blank" rel="noopener">
                            <img style="width: 20px; height: 20px;" src="<?php echo esc_url($bookmark['icon']); ?>" alt="<?php echo esc_attr($bookmark['title']); ?>"/>
                        </a>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
        <?php endif; ?>
    </div>
    <?php do_action('fluent_booking/booking_confirmation_footer', $booking); ?>
</div>
