<?php

namespace FluentBooking\App\Services\GlobalModules;

use FluentBooking\App\App;
use FluentBooking\App\Services\Helper;
use FluentBooking\Framework\Support\Arr;

class GlobalModules
{
    public function register()
    {
        add_filter('fluent_booking/settings_menu_items', [$this, 'addMenuItem'], 20);
    }

    public function addMenuItem($items)
    {
        $app = App::getInstance();
        $items['global_modules'] = [
            'title'          => __('Global Modules', 'fluent-booking-pro'),
            'icon_url'       => $app['url.assets'] . 'images/checklist.svg',
            'component_type' => 'StandAloneComponent',
            'route'          => [
                'name' => 'globalModules'
            ]
        ];

        return $items;
    }

    public function getAllModules()
    {
        $assetUrl = App::getInstance('url.assets');
        $settings = Helper::getGlobalModuleSettings();
        return apply_filters('fluent_booking/global_modules', [
            'woo'        => [
                'logo'           => $assetUrl . 'images/woo.svg',
                'name'           => 'woo',
                'title'          => __('WooCommerce', 'fluent-booking-pro'),
                'description'    => __('Accept payment on your booking appointment with WooCommerce Checkout', 'fluent-booking-pro'),
                'is_unavailable' => !defined('WC_PLUGIN_FILE'),
                'is_system'      => 'no',
                'is_active'      => Arr::get($settings, 'woocommerce') == 'yes',
            ],
            'fluentcrm'  => [
                'logo'           => $assetUrl . 'images/fluentcrm.svg',
                'name'           => 'fluentcrm',
                'title'          => __('FluentCRM', 'fluent-booking-pro'),
                'description'    => __('Segment your guests, send bulk emails, run automations using FluentCRM', 'fluent-booking-pro'),
                'is_unavailable' => defined('FLUENTCRM'),
                'install_url'    => admin_url('plugin-install.php?s=FluentCRM&tab=search&type=term'),
                'is_system'      => 'yes',
                'is_active'      => defined('FLUENTCRM')
            ],
            'fluentform' => [
                'logo'           => $assetUrl . 'images/fluentform.png',
                'name'           => 'fluentform',
                'title'          => __('Fluent Forms', 'fluent-booking-pro'),
                'description'    => __('Create beautiful booking forms using Fluent Forms with your booking field', 'fluent-booking-pro'),
                'is_unavailable' => defined('FLUENTFORM'),
                'install_url'    => admin_url('plugin-install.php?s=Fluent%20Forms&tab=search&type=term'),
                'is_system'      => 'yes',
                'is_active'      => defined('FLUENTFORM')
            ]
        ]);
    }
}
