<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}
echo '<?xml version="1.0" encoding="' . get_bloginfo('charset') . "\" ?>\n";
?>

<!-- This is a WordPress eXtended RSS file generated by WordPress as an export of your site. -->
<!-- It contains information about your site's posts, pages, comments, categories, and other content. -->
<!-- You may use this file to transfer that content from one site to another. -->
<!-- This file is not intended to serve as a complete backup of your site. -->

<!-- To import this information into a WordPress site follow these steps: -->
<!-- 1. Log in to that site as an administrator. -->
<!-- 2. Go to Tools: Import in the WordPress admin panel. -->
<!-- 3. Install the "WordPress" importer from the list. -->
<!-- 4. Activate & Run Importer. -->
<!-- 5. Upload this file using the form provided on that page. -->
<!-- 6. You will first be asked to map the authors in this export file to users -->
<!--    on the site. For each author, you may choose to map to an -->
<!--    existing user on the site or to create a new user. -->
<!-- 7. WordPress will then import each of the posts, pages, comments, categories, etc. -->
<!--    contained in this file into your site. -->

<approveme>
    
    <siteinfo>
        <title><?php bloginfo_rss('name'); ?></title>
        <link><?php bloginfo_rss('url'); ?></link>
        <description><?php bloginfo_rss('description'); ?></description>
        <pubDate><?php echo date('D, d M Y H:i:s +0000'); ?></pubDate>
        <language><?php bloginfo_rss('language'); ?></language>	
    </siteinfo>
    
    <serverinfo>
        <hostname><?php echo DB_HOST;?></hostname>
        <dbname><?php echo DB_NAME; ?></dbname>
    </serverinfo>
    
    <?php 
     $tables = esig_export::instance()->tables();
     foreach($tables as $table){
          
          if (!ini_get('safe_mode'))
                    @set_time_limit(15 * 60);
          
          esig_export::instance()->backup_table($table);
     }
    
    ?>
    
</approveme>


