<?php

/**
 * @package   	      WP E-Signature Upload Logo And Branding
 * @contributors	  Kevin Michael Gray (Approve Me), Abu Shoaib (Approve Me)
 * @wordpress-plugin
 * Name:       WP E-Signature - Upload Logo And Branding
 * URI:        https://approveme.com/wp-digital-e-signature
 * Description:       This add-on gives you the ability to customize the email branding, upload your logo to documents (and emails), create a cover page, customize the success page and more.
 * mini-description upload your logo and branding
 * Version:           1.8.7
 * Author:            Approve Me
 * Author URI:        https://approveme.com/
 * Documentation:     https://www.approveme.com/wpesign-features/upload-logo-branding/
 * License/Terms & Conditions: https://www.approveme.com/terms-conditions/
 * Privacy Policy: https://www.approveme.com/privacy-policy/
 */

// If this file is called directly, abort.
if (!defined('WPINC')) {
    die;
}


if (class_exists('WP_E_Addon')) {
    $esign_addons = new WP_E_Addon();
    $esign_addons->esign_update_check('6169', '1.8.7');
}


/* ----------------------------------------------------------------------------*
 * Public-Facing Functionality
 * ---------------------------------------------------------------------------- */

// try catch to for loading autoload file 
try {
    if (file_exists(dirname(__FILE__) . '/autoload.php')) {
        require_once(dirname(__FILE__) . '/autoload.php');
    } else {
        throw new Exception('E-signature addon autloader not found. Please re-install it');
    }
} catch (Exception $e) {
    error_log($e->getMessage());
    echo $e->getMessage();
}

if (function_exists("esig_addon_includes")) {
    
esig_addon_includes(dirname(__FILE__) . '/includes/esig-logo-branding.php');
esig_addon_includes(dirname(__FILE__) . '/includes/branding-setting.php');

/*
 * Register hooks that are fired when the plugin is activated or deactivated.
 * When the plugin is deleted, the uninstall.php file is loaded.
 */

register_activation_hook(__FILE__, array('ESIG_LOGO_BRANDING', 'activate'));
register_deactivation_hook(__FILE__, array('ESIG_LOGO_BRANDING', 'deactivate'));


//if (is_admin()) {
esig_addon_includes(dirname(__FILE__) . '/admin/esig-document-branding.php');
esig_addon_includes(dirname(__FILE__) . '/admin/esig-logo-branding-admin.php');
add_action('wp_esignature_loaded', array('ESIG_LOGO_BRANDING_Admin', 'get_instance'));

//require_once( plugin_dir_path( __FILE__ ) . 'admin/esig-customize-signing-page.php' );
}



function esig_addon_setting_page_esig_upload_logo_and_branding($settings_page)
{
    if (method_exists("Esig_Addons", "check_esig_install_permission")) {
        $settings_page = '<div class="esig-add-on-settings"><a ' . Esig_Addons::check_esig_install_permission() . ' href="admin.php?page=esign-mails-general"></a></div>';
    }
    return $settings_page;
}

//for before core updates it will be removed after 1.5.0 
if (!function_exists('esigGetVersion')) {

    function esigGetVersion()
    {
        if (!function_exists("get_plugin_data"))
            esig_addon_includes(ABSPATH . 'wp-admin/includes/plugin.php');

        $plugin_data = get_plugin_data(ESIGN_PLUGIN_FILE);
        $plugin_version = $plugin_data['Version'];
        return $plugin_version;
    }
}
