<?php

namespace esig_upload_logo_branding; 

class esigDocumentBranding
{
    public static function init()
    {
        add_action("esig_display_advanced_settings",[__CLASS__,"display_settings"],10,1);
        add_action("esig_display_docucment_title", [__CLASS__, "hide_document_title"], 10, 2);
        add_action("esig_document_advanced_settings",[__CLASS__,"settings_saved"],10,2);
    }

    public static function hide_document_title($bool,$docId)
    {

        if(self::isDocTitleHidden($docId))
        {
           
            return false;
        }

        return $bool;
    }

    public static function settings_saved($docId,$data)
    {
         // Saving document title hide settins here 
         WP_E_Sig()->meta->add($docId, "esig_hide_document_title",esigget("esig_hide_document_title",$data));   
    }

    public static function display_settings($docId)
    {       
       if(esigget('esig_type') != 'template'){
            include_once "view/document-advanced-settings.php";
       }        
    }

    public static function isDocTitleHidden($docId)
    { 
       $hideTitle = WP_E_Sig()->meta->get($docId, "esig_hide_document_title");
       if($hideTitle)
       {
           return true;
       }
       return false;
    }

    public static function isDocTitleHiddenTemp($docId)
    {
      
       $hideTitleTemp =  WP_E_Sig()->meta->get($docId, "esig_hide_document_title_template");

       if($hideTitleTemp)
       {
           return true;
       }
       return false;
    }
}

esigDocumentBranding::init();

