<?php

/**
 * @package   	      WP E-Signature - Google reCaptcha
 * @contributors      Kevin Michael Gray (Approve Me), Abu Shoaib (Approve Me)
 * @wordpress-plugin
 * Name:       WP E-Signature - Google reCaptcha
 * Plugin URI:        https://www.approveme.com/wp-digital-e-signature
 * Description:       This add-on automatically validate google reCaptcha for e-signature contracts submissions.
 * mini-description:  connect with your Active Campaign CRM
 * Version:           1.8.7
 * Author:            Approve Me
 * AuthorURI:        https://approveme.com/
 * Documentation:   https://wpe.approveme.com/article/177-wp-e-signature-google-recaptcha-add-on
 * License/TermsandConditions: https://www.approveme.com/terms-conditions/
 * PrivacyPolicy: https://www.approveme.com/privacy-policy/
 */

 // If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

 // esig google captcah plugin path
            if (!defined('ESIGN_GOOGLE_CAPTCHA_PATH'))
                   define('ESIGN_GOOGLE_CAPTCHA_PATH', dirname(__FILE__));
            
            // esig asset directory url
            if (!defined('ESIGN_RECAPTCHA_ASSET_URI'))
                  define('ESIGN_RECAPTCHA_ASSET_URI', plugins_url('assets', __FILE__));

// try catch to for loading autoload file 
try {
       if (file_exists(dirname(__FILE__) . '/autoload.php')) {
              require_once(dirname(__FILE__) . '/autoload.php');
       } else {
              throw new Exception('E-signature addon autloader not found. Please re-install it');
       }
} catch (Exception $e) {
       error_log($e->getMessage());
       echo $e->getMessage();
}


// check if esig_addon_includes function is not exists 
if (function_exists('esig_addon_includes')) {

       esig_addon_includes(ESIGN_GOOGLE_CAPTCHA_PATH . '/includes/class-google-recaptcha-settting.php');
       esig_addon_includes(ESIGN_GOOGLE_CAPTCHA_PATH . '/controllers/recaptchaController.php');
       esig_addon_includes(ESIGN_GOOGLE_CAPTCHA_PATH . '/includes/class-google-recaptcha.php');
       ESIG_GOOGLE_CAPTCHA::Init();
}

