<?php

use Kunnu\Dropbox\Dropbox;
use Kunnu\Dropbox\DropboxApp;


if (!class_exists('esigDsSetting')):

    class esigDsSetting {

        protected static $instance = null;
        protected $_appKey = 'zdn6lqvdny9nafx';
        protected $_secretKey = 'tqf7ipkb5hsies2';
        protected $_accessCode = 'esig-ds-access-code';
        protected $_dsTokenInfo = 'esig-ds-token-info';
        private $accessCode = null;
        protected $dataTokens;

        public static function instance() {
            includes_esig_dropbox();
            // If the single instance hasn't been set, set it now.
            if (null == self::$instance) {
                self::$instance = new self;
            }
            return self::$instance;
        }

        public function dsApi($accessCode = false) {
            if ($accessCode) {
                $app = new DropboxApp($this->_appKey, $this->_secretKey, $accessCode);
            } else {
                $app = new DropboxApp($this->_appKey, $this->_secretKey);
            }
            return new Dropbox($app);
        }

        public function authHelper() {
            return $this->dsApi()->getAuthHelper();
        }

        public function OAuth2Client()
        {
            return $this->dsApi()->getOAuth2Client();
        }

        public function authUrl() {
            return $this->authHelper()->getAuthUrl(null,["token_access_type"=>"offline"]);
        }

        public function saveAccessCode($value) {
            WP_E_Sig()->setting->set_generic($this->_accessCode, $value);
        }

        public function saveTokenInfo($value)
        {
            if(is_array($value))
            {
                $value['saveTime'] = date('Y-m-d H:i:s');
            }
            WP_E_Sig()->setting->set_generic($this->_dsTokenInfo, json_encode($value));
        }

        public function updateTokenInfo($tokens)
        {
            $accessToken = esigget("access_token",$tokens);
            $expires_in =  esigget("expires_in", $tokens);
            $tokenInfo = $this->getTokenInfo();
            $tokenInfo["access_token"] = $accessToken;
            $tokenInfo["expires_in"] = $expires_in;
            $this->saveTokenInfo($tokenInfo);
        }

        public function getAccessCode() {

            if(is_null($this->accessCode))
            {
                $this->accessCode = WP_E_Sig()->setting->get_generic($this->_accessCode);
            }
            return $this->accessCode;
        }

        public function getTokenInfo()
        {
            return json_decode(WP_E_Sig()->setting->get_generic($this->_dsTokenInfo),true); 
        }

        public function getToken($name)
        {
            if(is_null($this->dataTokens))
            {
                $this->dataTokens =  $this->getTokenInfo();
            }
            return esigget($name,$this->dataTokens);
        }

        public function tokenExpireIn()
        {
            return $this->getToken("expires_in");
        }

        public function tokenSaveTime()
        {
            return $this->getToken("saveTime");
        }

        public function refreshToken()
        {
            return $this->getToken("refresh_token");
        }

        public function getAccessToken()
        {
            return $this->getToken("access_token");
        }

        public function removeAuthorization() {
             WP_E_Sig()->setting->delete_generic($this->_accessCode);
            WP_E_Sig()->setting->delete_generic($this->_dsTokenInfo);
        }

        public function isTokenExpire()
        {
            $expireIn = $this->tokenExpireIn();
            if(!$expireIn) return true;
            $saveTime = $this->tokenSaveTime();
            $start = new DateTime($saveTime);
            $end = new DateTime(date('Y-m-d H:i:s'));
            // sets one min ahead. 
            $difference = $end->getTimestamp() - $start->getTimestamp() +60; 
            if($expireIn <= $difference) return true;
            return false;
        }

        public function isAEnabled()
        {
            $accessToken = $this->getAccessToken();
            if (empty($accessToken)) return false;
            return true;
        }

        public function isAuthorized() 
        {
            $accessToken = $this->getAccessToken();
            if (empty($accessToken)) return false;
            if($this->isTokenExpire())
            {
                $checkToken = $this->checkToken();
                if(!$checkToken) {
                    return false;
                } else 
                {
                    $this->dataTokens = null;
                }  
            }
            return true;
        }

        public function checkToken()
        {
            $tokens = $this->generateRefreshToken();
            if (!is_array($tokens)) return false;
            $accessToken = esigget("access_token", $tokens);
            if (!$accessToken) return false;
            $this->updateTokenInfo($tokens);
            return true;
        }

        public function generateToken($token) {
            $tokens = $this->OAuth2Client()->getAccessToken($token);
            return $tokens;
        }

        public function generateRefreshToken()
        {

            $params = [
                'refresh_token' => $this->refreshToken(),
                'grant_type' => "refresh_token",
                'client_id' => $this->OAuth2Client()->getApp()->getClientId(),
                'client_secret' => $this->OAuth2Client()->getApp()->getClientSecret(),
                'redirect_uri' => null
            ];

            $params = http_build_query($params);
            $apiUrl = $this->OAuth2Client()::AUTH_TOKEN_URL;
            $uri = $apiUrl . "?" . $params;
           
            //Send Request through the DropboxClient
            //Fetch the Response (DropboxRawResponse)
            $response = $this->OAuth2Client()->getClient()
            ->getHttpClient()
            ->send($uri, "POST", null);

            //Fetch Response Body
            $body = $response->getBody();

            return json_decode((string) $body, true);
           // $tokens = $this->OAuth2Client()->getAccessToken($this->refreshToken(),null, "refresh_token");
           // return $tokens;
        }

        public function account() {
            $accessCode = $this->getAccessToken();
            $dropbox = $this->dsApi($accessCode);
            try {
                return $dropbox->getCurrentAccount();
            } catch (Exception $ex) {
                return $ex->getMessage();
            }
        }

        public function spaceUsed() {

            $accessCode = $this->getAccessToken();
            $dropbox = $this->dsApi($accessCode);
            try {
                return $dropbox->getSpaceUsage();
            } catch (Exception $ex) {
                return $ex->getMessage();
            }
        }

        public function uploadFile($filePath, $fileName) {
            $accessCode = $this->getAccessToken();
            $dropbox = $this->dsApi($accessCode);
            $file = $dropbox->upload($filePath, "/" . $fileName, ['autorename' => true]);
            return $file;
        }

       

    }
  
 endif;
