<?php
/**
 * @package   	      WP E-Signature Add Custom Message to Signature invite
 * @contributors	  Kevin Michael Gray (Approve Me), Abu Shoaib (Approve Me)
 * @wordpress-plugin
 * Name:       WP E-Signature - Add Custom Message to Email
 * Plugin URI:        https://approveme.com/wp-digital-e-signature
 * Description:       Add Custom Message to Signature invitation email .
 * mini-description:  add custom message to your email
 * Version:           1.8.7
 * Author:            Approve Me
 * Documentation:     https://wpe.approveme.com/article/add-custom-message-email-feature/
 * Author URI:        https://approveme.com/
 */

 // If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}


if(class_exists( 'WP_E_Addon' ))
{
	$esign_addons= new WP_E_Addon();
	$esign_addons->esign_update_check('7878', '1.8.7');
}

// try catch to for loading autoload file 
try {
    if (file_exists(dirname(__FILE__) . '/autoload.php')) {
        require_once(dirname(__FILE__) . '/autoload.php');
    } else {
        throw new Exception('E-signature addon autloader not found. Please re-install it');
    }
} catch (Exception $e) {
    error_log($e->getMessage());
    echo $e->getMessage();
}

// check if esig_addon_includes function exists
if (function_exists("esig_addon_includes")) {

esig_addon_includes( dirname( __FILE__ ) . '/admin/esig-add-custom-message.php' );
add_action( 'wp_esignature_loaded', array( 'ESIG_CUSTOM_MESSAGE', 'instance' ) );

}

//for before core updates it will be removed after 1.5.0 
if (!function_exists('esigGetVersion')) {

    function esigGetVersion() {
        if (!function_exists("get_plugin_data"))
                esig_addon_includes(ABSPATH . 'wp-admin/includes/plugin.php');

        $plugin_data = get_plugin_data(ESIGN_PLUGIN_FILE);
        $plugin_version = $plugin_data['Version'];
        return $plugin_version;
    }

}

