<?php
/**
 * @package   	      WP E-Signature - Active Campaign
 * @contributors      Kevin Michael Gray (Approve Me), Abu Shoaib (Approve Me)
 * @wordpress-plugin
 * Name:       WP E-Signature - ActiveCampaign
 * Plugin URI:        https://www.approveme.com/wp-digital-e-signature
 * Description:       This add-on automatically subscribes (and tags) your signers to this powerful email marketing software which lets your create custom email sequences for your signers.
 * mini-description:  connect with your Active Campaign CRM
 * Version:           1.8.7
 * Author:            Approve Me
 * AuthorURI:        https://approveme.com/
 * Documentation:   https://wpe.approveme.com/article/127-wp-digital-e-signature-active-campaign-email-automation
 * License/TermsandConditions: https://www.approveme.com/terms-conditions/
 * PrivacyPolicy: https://www.approveme.com/privacy-policy/
 */

// If this file is called directly, abort.
if (!defined('WPINC')) {
    die;
}


if (class_exists('WP_E_Addon')) {
    $esign_addons = new WP_E_Addon();
    $esign_addons->esign_update_check('3491', '1.8.7');
}



//if (is_admin()) {
try {
    if (file_exists(dirname(__FILE__) . '/autoload.php')) {
        require_once(dirname(__FILE__) . '/autoload.php');
    } else {
        throw new Exception('E-signature addon autloader not found. Please re-install it');
    }
} catch (Exception $e) {
    error_log($e->getMessage());
    echo $e->getMessage();
}


if (function_exists("esig_addon_includes")) {

esig_addon_includes(dirname(__FILE__) . '/admin/esig-active-campaign-admin.php');

add_action('wp_esignature_loaded', array('ESIG_ACTIVE_CAMPAIGN_Admin', 'get_instance'));

}




function esig_addon_setting_page_esig_active_campaign($settings_page)
{

    if (method_exists("Esig_Addons", "check_esig_install_permission")) {
        $settings_page = '<div class="esig-add-on-settings"><a ' . Esig_Addons::check_esig_install_permission() . '  href="admin.php?page=esign-misc-general"></a></div>';
    }
    return $settings_page;
}


//for before core updates it will be removed after 1.5.0 
if (!function_exists('esigGetVersion')) {

    function esigGetVersion()
    {
        if (!function_exists("get_plugin_data"))
                esig_addon_includes(ABSPATH . 'wp-admin/includes/plugin.php');

        $plugin_data = get_plugin_data(ESIGN_PLUGIN_FILE);
        $plugin_version = $plugin_data['Version'];
        return $plugin_version;
    }
}
